/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.asneditor;

import java.util.ArrayList;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICodeAssist;
import org.asnlab.asndt.internal.ui.asneditor.AsnEditor;
import org.asnlab.asndt.internal.ui.asneditor.AsnElementHyperlink;
import org.asnlab.asndt.internal.ui.asneditor.EditorUtility;
import org.asnlab.asndt.internal.ui.text.AsnWordFinder;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsnElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IAsnElement[] elements;
        IRegion wordRegion;
        IAction openAction;
        block9: {
            IAsnElement input;
            block8: {
                ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                if (region == null || !(textEditor instanceof AsnEditor)) {
                    return null;
                }
                openAction = textEditor.getAction("OpenEditor");
                if (!(openAction instanceof SelectionDispatchAction)) {
                    return null;
                }
                int offset = region.getOffset();
                input = EditorUtility.getEditorInputAsnElement((IEditorPart)textEditor, false);
                if (input == null) {
                    return null;
                }
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                wordRegion = AsnWordFinder.findWord(document, offset);
                if (wordRegion != null && wordRegion.getLength() != 0) break block8;
                return null;
            }
            elements = null;
            elements = ((ICodeAssist)input).codeSelect(wordRegion.getOffset());
            elements = this.selectOpenableElements(elements);
            if (elements != null && elements.length != 0) break block9;
            return null;
        }
        try {
            IHyperlink[] result = new IHyperlink[elements.length];
            int i = 0;
            while (i < elements.length) {
                result[i] = new AsnElementHyperlink(wordRegion, (SelectionDispatchAction)openAction, elements[i], elements.length > 1);
                ++i;
            }
            return result;
        }
        catch (AsnModelException asnModelException) {
            return null;
        }
    }

    private IAsnElement[] selectOpenableElements(IAsnElement[] elements) {
        if (elements == null) {
            return null;
        }
        ArrayList<IAsnElement> result = new ArrayList<IAsnElement>(elements.length);
        int i = 0;
        while (i < elements.length) {
            IAsnElement element = elements[i];
            switch (element.getElementType()) {
                case 1: 
                case 2: 
                case 4: {
                    break;
                }
                default: {
                    result.add(element);
                }
            }
            ++i;
        }
        return result.toArray(new IAsnElement[result.size()]);
    }
}

