/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.ui.text;

import java.util.Map;
import java.util.Vector;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.formatter.ContentFormatter;
import org.asnlab.asndt.core.formatter.IPositionAwareFormattingStrategy;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.asneditor.ICompilationUnitDocumentProvider;
import org.asnlab.asndt.internal.ui.text.AbstractAsnScanner;
import org.asnlab.asndt.internal.ui.text.AsnCommentScanner;
import org.asnlab.asndt.internal.ui.text.AsnCompositeReconcilingStrategy;
import org.asnlab.asndt.internal.ui.text.AsnElementProvider;
import org.asnlab.asndt.internal.ui.text.AsnOutlineInformationControl;
import org.asnlab.asndt.internal.ui.text.AsnPresentationReconciler;
import org.asnlab.asndt.internal.ui.text.AsnReconciler;
import org.asnlab.asndt.internal.ui.text.HTMLAnnotationHover;
import org.asnlab.asndt.internal.ui.text.HTMLTextPresenter;
import org.asnlab.asndt.internal.ui.text.PreferencesAdapter;
import org.asnlab.asndt.internal.ui.text.SingleTokenAsnScanner;
import org.asnlab.asndt.internal.ui.text.asn.AsnAutoIndentStrategy;
import org.asnlab.asndt.internal.ui.text.asn.AsnCodeScanner;
import org.asnlab.asndt.internal.ui.text.asn.AsnDoubleClickSelector;
import org.asnlab.asndt.internal.ui.text.asn.AsnFormattingStrategy;
import org.asnlab.asndt.internal.ui.text.asn.AsnStringAutoIndentStrategy;
import org.asnlab.asndt.internal.ui.text.asn.AsnStringDoubleClickSelector;
import org.asnlab.asndt.internal.ui.text.asn.AsndocDoubleClickStrategy;
import org.asnlab.asndt.internal.ui.text.asn.SmartSemicolonAutoEditStrategy;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnEditorTextHoverDescriptor;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnEditorTextHoverProxy;
import org.asnlab.asndt.internal.ui.text.asn.hover.AsnInformationProvider;
import org.asnlab.asndt.ui.text.AsnTextTools;
import org.asnlab.asndt.ui.text.IColorManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class AsnSourceViewerConfiguration
extends TextSourceViewerConfiguration {
    private AsnTextTools fAsnTextTools;
    private ITextEditor fTextEditor;
    private String fDocumentPartitioning;
    private AbstractAsnScanner fCodeScanner;
    private AbstractAsnScanner fMultilineCommentScanner;
    private AbstractAsnScanner fSinglelineCommentScanner;
    private AbstractAsnScanner fStringScanner;
    private IColorManager fColorManager;
    private AsnDoubleClickSelector fAsnDoubleClickSelector;

    public AsnSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    public AsnSourceViewerConfiguration(AsnTextTools tools, ITextEditor editor) {
        super(AsnSourceViewerConfiguration.createPreferenceStore(tools));
        this.fAsnTextTools = tools;
        this.fColorManager = tools.getColorManager();
        this.fCodeScanner = (AbstractAsnScanner)this.fAsnTextTools.getCodeScanner();
        this.fMultilineCommentScanner = (AbstractAsnScanner)this.fAsnTextTools.getMultilineCommentScanner();
        this.fSinglelineCommentScanner = (AbstractAsnScanner)this.fAsnTextTools.getSinglelineCommentScanner();
        this.fStringScanner = (AbstractAsnScanner)this.fAsnTextTools.getStringScanner();
        this.fTextEditor = editor;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    protected ITextEditor getEditor() {
        return this.fTextEditor;
    }

    protected IPreferenceStore getPreferenceStore() {
        Assert.isTrue((!this.isNewSetup() ? 1 : 0) != 0);
        return this.fAsnTextTools.getPreferenceStore();
    }

    private boolean isNewSetup() {
        return this.fAsnTextTools == null;
    }

    private static final IPreferenceStore createPreferenceStore(AsnTextTools asnTextTools) {
        Assert.isNotNull((Object)asnTextTools);
        IPreferenceStore generalTextStore = EditorsUI.getPreferenceStore();
        if (asnTextTools.getCorePreferenceStore() == null) {
            return new ChainedPreferenceStore(new IPreferenceStore[]{asnTextTools.getPreferenceStore(), generalTextStore});
        }
        return new ChainedPreferenceStore(new IPreferenceStore[]{asnTextTools.getPreferenceStore(), new PreferencesAdapter(asnTextTools.getCorePreferenceStore()), generalTextStore});
    }

    private void initializeScanners() {
        Assert.isTrue((boolean)this.isNewSetup());
        this.fCodeScanner = new AsnCodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new AsnCommentScanner(this.getColorManager(), this.fPreferenceStore, "asn_multi_line_comment");
        this.fSinglelineCommentScanner = new AsnCommentScanner(this.getColorManager(), this.fPreferenceStore, "asn_single_line_comment");
        this.fStringScanner = new SingleTokenAsnScanner(this.getColorManager(), this.fPreferenceStore, "asn_string");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        AsnPresentationReconciler reconciler = new AsnPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__asn_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__asn_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__asn_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__asn_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__asn_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__asn_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__asn_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__asn_character");
        return reconciler;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        ITextEditor editor = this.getEditor();
        if (editor != null && editor.isEditable()) {
            AsnCompositeReconcilingStrategy strategy = new AsnCompositeReconcilingStrategy(editor, this.getConfiguredDocumentPartitioning(sourceViewer));
            AsnReconciler reconciler = new AsnReconciler(editor, strategy, false);
            reconciler.setIsIncrementalReconciler(false);
            reconciler.setIsAllowedToModifyDocument(false);
            reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
            reconciler.setDelay(500);
            return reconciler;
        }
        return null;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        String partitioning = this.getConfiguredDocumentPartitioning(sourceViewer);
        if ("__asn_string".equals(contentType)) {
            return new IAutoEditStrategy[]{new SmartSemicolonAutoEditStrategy(partitioning), new AsnStringAutoIndentStrategy(partitioning)};
        }
        if ("__asn_character".equals(contentType) || "__dftl_partition_content_type".equals(contentType)) {
            return new IAutoEditStrategy[]{new SmartSemicolonAutoEditStrategy(partitioning), new AsnAutoIndentStrategy(partitioning, this.getProject())};
        }
        return new IAutoEditStrategy[]{new AsnAutoIndentStrategy(partitioning, this.getProject())};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__asn_asndoc".equals(contentType)) {
            return new AsndocDoubleClickStrategy();
        }
        if ("__asn_multiline_comment".equals(contentType) || "__asn_singleline_comment".equals(contentType)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if ("__asn_string".equals(contentType) || "__asn_character".equals(contentType)) {
            return new AsnStringDoubleClickSelector(this.getConfiguredDocumentPartitioning(sourceViewer));
        }
        if (this.fAsnDoubleClickSelector == null) {
            this.fAsnDoubleClickSelector = new AsnDoubleClickSelector();
        }
        return this.fAsnDoubleClickSelector;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"--", ""};
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        IAsnProject project = this.getProject();
        int spaceEquivalents = Math.min(1, 2);
        boolean useSpaces = project == null;
        int i = 0;
        while (i <= spaceEquivalents) {
            int j;
            StringBuffer prefix = new StringBuffer();
            if (useSpaces) {
                j = 0;
                while (j + i < spaceEquivalents) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != 0) {
                    prefix.append('\t');
                }
            } else {
                j = 0;
                while (j < i) {
                    prefix.append(' ');
                    ++j;
                }
                if (i != spaceEquivalents) {
                    prefix.append('\t');
                }
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add("");
        return vector.toArray(new String[vector.size()]);
    }

    private IAsnProject getProject() {
        ICompilationUnit element = this.getCompilationUnit();
        if (element == null) {
            return null;
        }
        return element.getAsnProject();
    }

    private ICompilationUnit getCompilationUnit() {
        ITextEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        ICompilationUnit cu = null;
        IEditorInput input = editor.getEditorInput();
        IDocumentProvider provider = editor.getDocumentProvider();
        if (provider instanceof ICompilationUnitDocumentProvider) {
            ICompilationUnitDocumentProvider cudp = (ICompilationUnitDocumentProvider)provider;
            cu = cudp.getWorkingCopy(input);
        }
        return cu;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return AsnSourceViewerConfiguration.this.isShowInVerticalRuler(annotation);
            }
        };
    }

    public IAnnotationHover getOverviewRulerAnnotationHover(ISourceViewer sourceViewer) {
        return new HTMLAnnotationHover(){

            protected boolean isIncluded(Annotation annotation) {
                return AsnSourceViewerConfiguration.this.isShowInOverviewRuler(annotation);
            }
        };
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        AsnEditorTextHoverDescriptor[] hoverDescs = AsnPlugin.getDefault().getAsnEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        AsnEditorTextHoverDescriptor[] hoverDescs = AsnPlugin.getDefault().getAsnEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new AsnEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.getEditor());
            }
            ++i;
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__asn_singleline_comment", "__asn_multiline_comment", "__asn_string", "__asn_character"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        ContentFormatter formatter = new ContentFormatter();
        ICompilationUnit compilationUnit = this.getCompilationUnit();
        formatter.setFormattingStrategy((IPositionAwareFormattingStrategy)new AsnFormattingStrategy(compilationUnit), "__dftl_partition_content_type");
        return formatter;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(true));
            }
        };
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 20;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new AsnOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }

    public IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        AsnInformationProvider provider = new AsnInformationProvider((IEditorPart)this.getEditor());
        String[] contentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < contentTypes.length) {
            presenter.setInformationProvider((IInformationProvider)provider, contentTypes[i]);
            ++i;
        }
        presenter.setSizeConstraints(60, 10, true, true);
        return presenter;
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer, boolean doCodeResolve) {
        InformationPresenter presenter = doCodeResolve ? new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.asnlab.asndt.ui.navigate.asn.open.structure")) : new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, "org.asnlab.asndt.ui.edit.text.asn.show.outline"));
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        AsnElementProvider provider = new AsnElementProvider((IEditorPart)this.getEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "__dftl_partition_content_type");
        presenter.setInformationProvider((IInformationProvider)provider, "__asn_singleline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__asn_multiline_comment");
        presenter.setInformationProvider((IInformationProvider)provider, "__asn_string");
        presenter.setInformationProvider((IInformationProvider)provider, "__asn_character");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = AsnPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = AsnPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    public boolean affectsTextPresentation(PropertyChangeEvent event) {
        return this.fCodeScanner.affectsBehavior(event) || this.fMultilineCommentScanner.affectsBehavior(event) || this.fSinglelineCommentScanner.affectsBehavior(event) || this.fStringScanner.affectsBehavior(event);
    }

    public void handlePropertyChangeEvent(PropertyChangeEvent event) {
        Assert.isTrue((boolean)this.isNewSetup());
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    protected Map getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.asnlab.asndt.ui.asnCode", this.fTextEditor);
        return targets;
    }
}

