/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui;

import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.internal.corext.util.AsnElementResourceMapping;
import org.asnlab.asndt.internal.ui.AsnElementContainmentAdapter;
import org.asnlab.asndt.internal.ui.AsnElementProperties;
import org.asnlab.asndt.internal.ui.AsnTaskListAdapter;
import org.asnlab.asndt.internal.ui.AsnWorkbenchAdapter;
import org.asnlab.asndt.internal.ui.IResourceLocator;
import org.asnlab.asndt.internal.ui.ResourceLocator;
import org.asnlab.asndt.internal.ui.search.AsnSearchPageScoreComputer;
import org.asnlab.asndt.internal.ui.search.SearchUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

public class AsnElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter,
IContributorResourceAdapter2 {
    private static Class[] PROPERTIES = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    private Object fSearchPageScoreComputer;
    private static IResourceLocator fgResourceLocator;
    private static AsnWorkbenchAdapter fgAsnWorkbenchAdapter;
    private static ITaskListResourceAdapter fgTaskListAdapter;
    private static AsnElementContainmentAdapter fgAsnElementContainmentAdapter;

    public Class[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return PROPERTIES;
    }

    public Object getAdapter(Object element, Class key) {
        this.updateLazyLoadedAdapters();
        IAsnElement asn = this.getAsnElement(element);
        if (IPropertySource.class.equals((Object)key)) {
            return this.getProperties(asn);
        }
        if (IResource.class.equals((Object)key)) {
            return this.getResource(asn);
        }
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals((Object)key)) {
            return this.fSearchPageScoreComputer;
        }
        if (IWorkbenchAdapter.class.equals((Object)key)) {
            return AsnElementAdapterFactory.getAsnWorkbenchAdapter();
        }
        if (IResourceLocator.class.equals((Object)key)) {
            return AsnElementAdapterFactory.getResourceLocator();
        }
        if (IContributorResourceAdapter.class.equals((Object)key)) {
            return this;
        }
        if (IContributorResourceAdapter2.class.equals((Object)key)) {
            return this;
        }
        if (ITaskListResourceAdapter.class.equals((Object)key)) {
            return AsnElementAdapterFactory.getTaskListAdapter();
        }
        if (IContainmentAdapter.class.equals((Object)key)) {
            return AsnElementAdapterFactory.getAsnElementContainmentAdapter();
        }
        return null;
    }

    private IResource getResource(IAsnElement element) {
        switch (element.getElementType()) {
            case 10: {
                IAsnElement parent = element.getParent();
                if (parent instanceof ICompilationUnit) {
                    return ((ICompilationUnit)parent).getPrimary().getResource();
                }
                return null;
            }
            case 5: {
                return ((ICompilationUnit)element).getPrimary().getResource();
            }
            case 4: {
                return element.getResource();
            }
            case 1: 
            case 2: {
                return element.getResource();
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        IAsnElement je = this.getAsnElement(adaptable);
        if (je != null) {
            return this.getResource(je);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        IAsnElement je = this.getAsnElement(adaptable);
        if (je != null) {
            return AsnElementResourceMapping.create(je);
        }
        return null;
    }

    private IAsnElement getAsnElement(Object element) {
        if (element instanceof IAsnElement) {
            return (IAsnElement)element;
        }
        return null;
    }

    private IPropertySource getProperties(IAsnElement element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return new AsnElementProperties(element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new AsnSearchPageScoreComputer();
        PROPERTIES = new Class[]{IPropertySource.class, IResource.class, ISearchPageScoreComputer.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IProject.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    }

    private static IResourceLocator getResourceLocator() {
        if (fgResourceLocator == null) {
            fgResourceLocator = new ResourceLocator();
        }
        return fgResourceLocator;
    }

    private static AsnWorkbenchAdapter getAsnWorkbenchAdapter() {
        if (fgAsnWorkbenchAdapter == null) {
            fgAsnWorkbenchAdapter = new AsnWorkbenchAdapter();
        }
        return fgAsnWorkbenchAdapter;
    }

    private static ITaskListResourceAdapter getTaskListAdapter() {
        if (fgTaskListAdapter == null) {
            fgTaskListAdapter = new AsnTaskListAdapter();
        }
        return fgTaskListAdapter;
    }

    private static AsnElementContainmentAdapter getAsnElementContainmentAdapter() {
        if (fgAsnElementContainmentAdapter == null) {
            fgAsnElementContainmentAdapter = new AsnElementContainmentAdapter();
        }
        return fgAsnElementContainmentAdapter;
    }
}

