/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.text;

import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.ui.text.AsnTextTools;
import org.asnlab.asndt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ContentAssistPreference {
    private static final String AUTOACTIVATION = "content_assist_autoactivation";
    private static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    private static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    private static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    private static final String AUTOINSERT = "content_assist_autoinsert";
    private static final String AUTOACTIVATION_TRIGGERS_ASN = "content_assist_autoactivation_triggers_asn";
    private static final String AUTOACTIVATION_TRIGGERS_ASNDOC = "content_assist_autoactivation_triggers_asndoc";
    private static final String SHOW_VISIBLE_PROPOSALS = "content_assist_show_visible_proposals";
    private static final String CASE_SENSITIVITY = "content_assist_case_sensitivity";
    private static final String FILL_METHOD_ARGUMENTS = "content_assist_fill_method_arguments";
    private static final String PREFIX_COMPLETION = "content_assist_prefix_completion";

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        AsnTextTools textTools = AsnPlugin.getDefault().getAsnTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        AsnTextTools textTools = AsnPlugin.getDefault().getAsnTextTools();
        IColorManager manager = textTools.getColorManager();
        boolean enabled = store.getBoolean(AUTOACTIVATION);
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND, manager);
        assistant.setProposalSelectorForeground(c);
        c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND, manager);
        assistant.setProposalSelectorBackground(c);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        enabled = store.getBoolean(PREFIX_COMPLETION);
        assistant.enablePrefixCompletion(enabled);
    }

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION.equals(p)) {
            boolean enabled = store.getBoolean(AUTOACTIVATION);
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PROPOSALS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND);
            assistant.setProposalSelectorForeground(c);
        } else if (PROPOSALS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND);
            assistant.setProposalSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        } else if (PREFIX_COMPLETION.equals(p)) {
            boolean enabled = store.getBoolean(PREFIX_COMPLETION);
            assistant.enablePrefixCompletion(enabled);
        }
    }

    public static boolean fillArgumentsOnMethodCompletion(IPreferenceStore store) {
        return store.getBoolean(FILL_METHOD_ARGUMENTS);
    }
}

